REM************************************************************************
REM
REM   Filename       :   DEMO2318.BAS     Version:  1.0
REM
REM   Entwickelt von :   PV               am 20.02.1993
REM
REM   Geaendert von  :   MT   V 2.0       am 30.07.2002
REM                      Zeichen werden einzeln gesendet aufgrund Probleme
REM                      mit schnelleren Rechnern.
REM   Sprache        :   QBASIC           Betriebssystem: MS-DOS 5.00
REM
REM   Funktion       :   Demoprogramm fuer den Resistomat Typ 2318 zur
REM                      Bedienung ueber die RS232 Schnittstelle
REM
REM************************************************************************
REM                        
CLS                            'Bildschirm loeschen
PRINT "                           DEMOPROGRAMM "
PRINT "                             burster                 "
PRINT "            Messwerte einlesen ueber RS232 Schnittstelle"
PRINT
PRINT
DIM ant$(50)
REM   Sonderzeichen werden definiert
STX$ = CHR$(2)
ETX$ = CHR$(3)
EOT$ = CHR$(4)
ENQ$ = CHR$(5)
ACK$ = CHR$(6)
NAK$ = CHR$(21)
CR$ = CHR$(13)
lf$ = CHR$(10)
ESC$ = CHR$(27)
com$ = ""
openstr$ = ""

PRINT
PRINT
INPUT "Welche Schnittstelle wollen Sie verwenden? (1 -> COM1, 2 -> COM2 ...)"; a
openstr$ = STR$(a)             'COM-Nr in String umwandeln
openstr$ = MID$(openstr$, 2)      'Space entfernen
openstr$ = "COM" + openstr$ + ":9600,N,8,1" 'Init-String
PRINT

OPEN openstr$ FOR RANDOM AS #1 ' RS232 INITIALISIEREN
messtart$ = EOT$ + "0000SR" + STX$ + "INIT" + lf$ + ETX$
fetch$ = EOT$ + "0000SR" + STX$ + "FETC?" + lf$ + ETX$
polling$ = EOT$ + "0000PO" + ENQ$
abort$ = EOT$ + "0000SR" + STX$ + "ABOR" + lf$ + ETX$

com$ = abort$                  'Messung beenden (ABORT)
GOSUB Senden
ant$ = ""                      'Antwortstring loeschen
ant$ = INPUT$(1, #1)           'Antwort einlesen
IF (ant$ <> ACK$) THEN         'Wenn nicht ACK
  PRINT "Geraet antwortet mit ABORT NAK"    'Fehlermeldung anzeigen
END IF

anzahl = 0
INPUT "Anzahl gewuenschter Messwerte: "; anzahl  'Anzahl Messwerte
PRINT

com$ = messtart$               'Messung beenden (INIT)
GOSUB Senden
ant$ = ""                      'Antwortstring loeschen
ant$ = INPUT$(1, #1)           'Antwort einlesen
IF (ant$ <> ACK$) THEN         'Wenn nicht ACK
  PRINT "Geraet antwortet mit INIT NAK"     'Fehlermeldung anzeigen
END IF

i = 0                          'Zaehler initialisieren
WHILE i < anzahl
  com$ = fetch$                'Messwert abholen (FETCH?)
  GOSUB Senden
  ant$ = ""                    'Antwortstring loeschen
  ant$ = INPUT$(1, #1)         'Antwort einlesen
  IF (ant$ <> ACK$) THEN       'Wenn nicht ACK
    PRINT "Geraet antwortet mit FETCH NAK"  'Fehlermeldung anzeigen
  END IF

polling:
  com$ = polling$              'Polling Sequenz
  GOSUB Senden
  ant$ = ""                    'Antwortstring loeschen
  stri$ = ""                   'Messwertstring loeschen
  ant$ = INPUT$(1, #1)
  WHILE (ant$ <> ETX$) AND (ant$ <> EOT$) 'Solange kein ETX und EOT empfangen
    ant$ = INPUT$(1, #1)       'Zeichen von RS232 einlesen
    IF ant$ >= CHR$(32) THEN   'Wenn keine Sonderzeichen
      stri$ = stri$ + ant$     'Messwertstring bilden
    END IF
  WEND
 
  IF (ant$ = EOT$) THEN GOTO polling
  i = i + 1
  'bei Messwert <= 0 sendet Geraet einen anderen Wert
  IF INSTR(1, stri$, "9.9999e+11") = 1 THEN
     stri$ = "0.0"             'Messwert auf 0 setzen
  END IF
  PRINT i; "  Messwert: "; VAL(stri$); " Ohm"
WEND

com$ = abort$
GOSUB Senden
ant$ = ""                      'Antwortstring loeschen
ant$ = INPUT$(1, #1)           'Antwort einlesen
IF (ant$ <> ACK$) THEN         'Wenn nicht ACK
  PRINT "Geraet antwortet mit ABORT NAK"      'Fehlermeldung anzeigen
END IF

END                            'Programm Beendet

Senden:                        'Befehl Senden (einzelne Zeichen)
   FOR l = 1 TO LEN(com$)
     s$ = MID$(com$, l, 1)
     PRINT #1, s$
     'Sendepuffer am PC ueberpruefen
     WHILE (INP(&H3FD) AND &H60) <> &H60 'Line-Status-Register 5 (F8+5)
	 'Warten bis Sendepuffer leer
     WEND: 'H20=Transmitter-Holding-register empty H40=Transmitter empty
   NEXT l
RETURN

